<?php

$rssFile = 'feed.xml'; // your RSS filename
$outputDir = 'grav-output/01.blog/';

if (!file_exists($outputDir)) {
    mkdir($outputDir, 0777, true);
}

$xml = simplexml_load_file($rssFile, 'SimpleXMLElement', LIBXML_NOCDATA);

$counter = 1;

foreach ($xml->channel->item as $item) {

    $title = trim((string) $item->title);

    if ($title === '') {
        $title = 'Untitled Post';
    }
    
    $date = date('Y-m-d H:i', strtotime((string) $item->pubDate));
    
    $slugBase = strtolower(preg_replace('/[^a-z0-9]+/i', '-', $title));
    $slugBase = trim($slugBase, '-');
    
    if ($slugBase === '') {
        $slugBase = 'post';
    }
    
    // Force uniqueness in URL portion
    $slugBase .= '-' . $counter;
    
    $slug = str_pad($counter, 4, '0', STR_PAD_LEFT) . '.' . $slugBase;
    
    $counter++;

    // Categories
    $categories = [];
    foreach ($item->category as $cat) {
        $categories[] = trim((string) $cat);
    }

    $categoryYaml = '';
    if (!empty($categories)) {
        $escaped = array_map(fn($c) => '"' . addslashes($c) . '"', $categories);
        $categoryYaml = "taxonomy:\n  category: [" . implode(', ', $escaped) . "]\n";
    }

    // Content (full HTML)
    $content = (string) $item->children('content', true)->encoded;

    // Create folder
    $postDir = $outputDir . $slug;
    if (!file_exists($postDir)) {
        mkdir($postDir, 0777, true);
    }

    // Build Grav file
    $gravFile = "---\n";
    $gravFile .= "title: \"" . addslashes($title) . "\"\n";
    $gravFile .= "date: $date\n";
    $gravFile .= $categoryYaml;
    $gravFile .= "---\n\n";
    $gravFile .= $content;

    file_put_contents($postDir . '/item.md', $gravFile);

    echo "Converted: $title\n";
}

echo "Done.\n";